function [pivots_out,centroid_stk,lum_stk] = find_centroid(varargin)
%This function uses imreginalmax to find the local max, and imhmax to
%threashold the maximas, then calculate the centroid from the local max.
%Also, find_centroid has type 3, which find_centroid2 does not.
%Synatax:   [pivots,centroid_stk,lum_stk] = find_centroid('stks',array,
%                               'theshold',0.5,'type',2,'type2',[0 1],'norm',1)
%Input:     'stks' = stacks to be processed. in a horizontal cell array.
%               BTW if you use stks, you must turn save off for now.
%           'threshold' = if left off no threshold will be given, if given
%               the value should be between [0 1], and only maxima above
%               the desired level will be counted. Now by Default threshold
%               is 10% or 0.1 for localmax, centroids = 0.1 or 10%
%           type = 1(centroid), 2 (WeightedCentroid) or 0(local max), ...
%               3(all pixels above threshold). default = 0(local max)
%           type2 = 1(Area), 2(Max Intensity), 3(Min Intensity), 4(Pixel #)
%                   5(Integrated Intensity), default = 0(Mean Intensity) 
%                   Note: only works with centroids
%           norm = normalize the images, essentially stretching the image
%                   data over the full bit range.  Only works in centroid
%                   mode.  Default = 1, or on, and will not affect the
%                   intensity  measurements.  If a value between 0 and 1 is
%                   entered then we go into imadjust mode. Note: a norm
%                   value of 0.99 means saturate 1% of pixels.
%           object = output the images of the objects.  Default = 0(off)
%               Does not work with local max
%           save = save the pivots files.  Default = 1 (on)
%           zfilter = filter the objects based on whether then are in
%               multiple slices or not.  Default = 0; 
%Output:    pivots = a x by 4 array, where x y z define the pivots
%               and the brightness of the centroid is the 4th column.
%           centroid_stk = the stacks reduced to the centroids.
%           lum_stk = the points with the actual brightness levels for each
%               local max

[stks,threshold,stks_ch_names,channel_paths,type,type2,norm,object,zfilter,sav] = parse(varargin);

%initiate labeling of matrix (happy now?!)
mxlabel = {'x','y','z'};

%matlabpool
%lets get straight on calculating the local max
%preallocate
centroid_stk = cell(1,size(stks,2));
lum_stk = cell(1,size(stks,2));
pivots_out = cell(1,size(stks,2));
if object
    object_stk = cell(1,size(stks,2));
    object_lum = cell(1,size(stks,2));
end
for i = 1:size(stks,2)
    stk_tmp = stks{1,i};        %take out the stack to work on.
    if norm==1  %normalize
        stk_tmp = imnorm(stk_tmp);    %normalize the image so that the bit depth is maximized.
    elseif norm>0 && norm<1     %imadjust mode
        lo_hi = stretchlim(max(stk_tmp,[],3),[0 norm]);   %generate the contrast range
        for l = 1:size(stk_tmp,3)   %enhance each image
            stk_tmp(:,:,l) = imadjust(stk_tmp(:,:,l),lo_hi,[]);
        end
    end
    %check for 32bit images
    if strcmp('uint32',class(stk_tmp))
        stk_tmp = im2double2(stk_tmp);  %convert to double for use
    end
    if ~type        %default (local max)
        %stks{1,i} = imhmax(stks{1,i},threshold{1,i});
        thresh_tmp = absmax(stks)*threshold;
        stk_tmp(stk_tmp<thresh_tmp) = 0;
        stks{1,i} = stk_tmp;
        centroid_stk{1,i} = imregionalmax(stks{1,i});
        %enforce object, must be 0
        object = 0;
    else
        stk_bw = false(size(stk_tmp));
        for j = 1:size(stks{1,i},3)     %make the stk Black & White
            stk_bw(:,:,j) = im2bw(stk_tmp(:,:,j),threshold);
        end
        stk_cc = bwconncomp(stk_bw);    %run the connected components analysis
        if zfilter
            pixlst = regionprops(stk_cc,'PixelList');   %find the objects in the volume
            pixidxlst = regionprops(stk_cc,'PixelIdxList');     %get the pixel indexs for the objects
            pixlst = struct2cell(pixlst);    %convert to cell for simple useage
            for n = 1:size(pixlst,2)        %step through the array
                pixtmp(n) = size(unique(pixlst{1,n}(:,3)),1);   %we only care about whether the z is single slice or multi
            end
            rmvidx = find(pixtmp==1);   %find the single slice objects
            pixidxlst(rmvidx) = [];     %remove the single slice objects
            %now convert back to image for later calculations...admittedly I don't
            %need to do this, but to keep the rest of the function the same, I will
            %do this extra step.
            object_idx = cell2mat(struct2cell(pixidxlst)');    %grab the indexs of all of the pixels
            object_tmp = false(size(stk_bw));    %stack holder
            object_tmp(object_idx) = 1;     %create the image
            stk_cc = bwconncomp(object_tmp);   %store
        end
        pixtmp = [];rmvidx = [];pixlst = [];pixidxlst = [];
        switch type  
            case 1    %Centroid
                pivots = regionprops(stk_cc,'Centroid');  %find centroid
                %pivots_out_tmp = cat(1,pivots.Centroid);
            case 2    %WeightedCentroid
                pivots = regionprops(stk_cc,stks{1,i},'WeightedCentroid');
                %pivots_out_tmp = cat(1,pivots.WeightedCentroid);
            case 3  %take all points
                pivots = regionprops(stk_cc,'PixelList');
        end
        lum = [];
        for m = 1:size(type2,2)
            switch type2(m)
                case 1      %area
                    if i==1     %only once
                        mxlabel = [mxlabel 'Area'];
                    end
                    if type==3  %pull all pixels
                        lum_tmp = regionprops(stk_cc,'PixelIdxList');
                        lum_tmp = cell2mat(struct2cell(lum_tmp)');
                        lum = [lum lum_tmp];
                    else    %only objects
                        lum_tmp = regionprops(stk_cc,'Area');
                        lum_tmp = struct2cell(lum_tmp);
                        lum = horzcat(lum,cell2mat(lum_tmp)');
                    end
                case 2      %max intensity
                    if i==1
                        mxlabel = [mxlabel 'MaxIntensity'];
                    end
                    if type==3  %pull all pixels
                        lum_tmp = regionprops(stk_cc,stks{1,i},'PixelValues');
                        lum_tmp = cell2mat(struct2cell(lum_tmp)');
                        lum = [lum lum_tmp];
                    else    %only objects
                        lum_tmp = regionprops(stk_cc,stks{1,i},'MaxIntensity');
                        lum_tmp = struct2cell(lum_tmp);
                        lum = horzcat(lum,cell2mat(lum_tmp)');
                    end
                case 3      %min intensity
                    if i==1
                        mxlabel = [mxlabel 'MinIntensity'];
                    end
                    if type==3  %pull all pixels
                        lum_tmp = regionprops(stk_cc,stks{1,i},'PixelValues');
                        lum_tmp = cell2mat(struct2cell(lum_tmp)');
                        lum = [lum lum_tmp];
                    else    %only objects
                        lum_tmp = regionprops(stk_cc,stks{1,i},'MinIntensity');
                        lum_tmp = struct2cell(lum_tmp);
                        lum = horzcat(lum,cell2mat(lum_tmp)');
                    end
                case 4      %Pixel Number
                    if i==1
                        mxlabel = [mxlabel 'VoxelNumber'];
                    end
                    if type==3  %pull all pixels
                        lum_tmp = regionprops(stk_cc,'PixelIdxList');
                        lum_tmp = cell2mat(struct2cell(lum_tmp)');
                        lum = [lum lum_tmp];
                    else %only objects
                        lum_tmp = regionprops(stk_cc,'PixelIdxList');
                        lum_tmp = struct2cell(lum_tmp);
                        for l = 1:size(lum_tmp,2); lum_tmp{l} = size(lum_tmp{l},1); end
                        lum = horzcat(lum,cell2mat(lum_tmp)');
                    end
                case 5      %Intensity Integrated
                    if i==1
                        mxlabel = [mxlabel 'IntegratedIntensity'];
                    end
                    if type==3  %pull all pixels
                        lum_tmp = regionprops(stk_cc,stks{1,i},'PixelValues');
                        lum_tmp = cell2mat(struct2cell(lum_tmp)');
                        lum = [lum lum_tmp];
                    else    %only objects
                        lum_tmp = regionprops(stk_cc,stk_tmp,'PixelValue');
                        lum_tmp = struct2cell(lum_tmp);
                        for l = 1:size(lum_tmp,2); lum_tmp{l} = sum(lum_tmp{l}); end
                        lum = horzcat(lum,cell2mat(lum_tmp)');
                    end
                otherwise
                    if i==1
                        mxlabel = [mxlabel 'MeanIntensity'];
                    end
                    if type==3  %pull all pixels
                        lum_tmp = regionprops(stk_cc,stks{1,i},'PixelValues');
                        lum_tmp = cell2mat(struct2cell(lum_tmp)');
                        lum = [lum lum_tmp];
                    else    %only objects
                        lum_tmp = regionprops(stk_cc,stks{1,i},'MeanIntensity');    %find the intensity of the regions
                        lum_tmp = struct2cell(lum_tmp);
                        lum = horzcat(lum,cell2mat(lum_tmp)');
                    end
            end
            lum_tmp = [];
        end
        stk_tmp = false(size(stks{1,i}));  %create a logical array the same size as the original array
        %pivots is currently a structure, convert to cell then matrix
        pivots = cell2mat(struct2cell(pivots)');
        %now make the pivots output by adding lum
        pivots_out_tmp = [pivots lum];
        %round pivots to use as pixel indexs
        pivots = round(pivots);
        %now calculate the indexs for the centroid locations
        [x,y,z] = size(stk_tmp);        %stack size
        pivots_idx = ((pivots(:,1)-1).*x)+pivots(:,2)+((x*y).*(pivots(:,3)-1));
        %modify stk_tmp
        stk_tmp(pivots_idx) = 1;
%         pivots_out_tmp = zeros(size(pivots,1),(3+size(lum,2)));
%         for k = 1:size(pivots,1)    %go through the pivots list
%             switch type
%                 case 1      %Centroid
%                     stk_tmp(round(pivots(k).Centroid(1,2)),round(pivots(k).Centroid(1,1)),round(pivots(k).Centroid(1,3))) = 1;  %make centroid_stk image
%                     %lum_tmp = single(stks{1,i}(round(pivots(k).Centroid(1,2)),round(pivots(k).Centroid(1,1)),round(pivots(k).Centroid(1,3))));
%                     %pivots_out_tmp(k,:) = [pivots(k).Centroid lum_tmp];
%                     pivots_out_tmp(k,:) = [pivots(k).Centroid lum(k,:)];
%                 case 2      %Weighted Centroid
%                     stk_tmp(round(pivots(k).WeightedCentroid(1,2)),round(pivots(k).WeightedCentroid(1,1)),round(pivots(k).WeightedCentroid(1,3))) = 1;  %make centroid_stk image
%                     %lum_tmp = single(stks{1,i}(round(pivots(k).WeightedCentroid(1,2)),round(pivots(k).WeightedCentroid(1,1)),round(pivots(k).WeightedCentroid(1,3))));
%                     %pivots_out_tmp(k,:) = [pivots(k).WeightedCentroid lum_tmp];
%                     pivots_out_tmp(k,:) = [pivots(k).WeightedCentroid lum(k,:)];
%             end
%         end
        centroid_stk{1,i} = stk_tmp;
        pivots_out{1,i} = pivots_out_tmp;
        if object   %if object is on
            object_idx = cell2mat(struct2cell(regionprops(stk_cc,'PixelIdxList'))');    %grab the indexs of all of the pixels
            object_tmp = false(size(stks{1,i}));    %stack holder
            object_tmp(object_idx) = 1;     %create the image
            object_stk{1,i} = object_tmp;   %store
            imgclass = class(stks{1,i});      %get image type
            switch imgclass
                case 'uint8'
                    object_lum{1,i} = stks{1,i}.*uint8(object_stk{1,i});   %preserve the luminance.
                case 'uint16'
                    object_lum{1,i} = stks{1,i}.*uint16(object_stk{1,i});   %preserve the luminance.
                case 'uint32'
                    object_lum{1,i} = stks{1,i}.*uint32(object_stk{1,i});   %preserve the luminance.
                case 'double'
                    object_lum{1,i} = stks{1,i}.*double(object_stk{1,i});   %preserve the luminance.
            end
            object_tmp = []; %clear!
        end
        %clear stk_tmp pivots_out_tmp stk_bw
        stk_tmp = []; pivots_out_tmp = [];stk_bw = [];stk_cc = [];
    end
    %Now pickup the brightness at the max
    switch imgclass
        case 'uint8'
            lum_stk{1,i} = stks{1,i}.*uint8(centroid_stk{1,i});
        case 'uint16'
            lum_stk{1,i} = stks{1,i}.*uint16(centroid_stk{1,i});
        case 'uint32'
            lum_stk{1,i} = stks{1,i}.*uint32(centroid_stk{1,i});
        case 'double'
            lum_stk{1,i} = stks{1,i}.*double(centroid_stk{1,i});
    end
end

%ok now find the points & the brightness
if ~type   %if local max
    for i = 1:size(centroid_stk,2)
        local_max_tmp = [];
        for j = 1:size(centroid_stk{1,i},3)
            [x_tmp,y_tmp] = find(centroid_stk{1,i}(:,:,j)>0);
            lm_cache = [x_tmp y_tmp repmat(j,size(x_tmp,1),1)];
            local_max_tmp = vertcat(local_max_tmp,lm_cache);
        end
        lum_tmp = double(lum_stk{1,i}(centroid_stk{1,i}));  %cast to double just in case someone will use huge pictures, because uint8 and 16 are limited
        pivots_out{1,i} = [local_max_tmp lum_tmp];
        if i==1
            mxlabel = [mxlabel 'LocalIntensity'];
        end
    end
end

if sav  %save the pivot files
    %localization for macs
    if ispc
        slash = '\';        %Windows directory marker
    else
        slash = '/';        %Mac directory marker
    end
    
    %dynamic path
    switch type
        case 0
            dir_path = ['LocalMaxs',slash];     %where to save it
        case 1
            dir_path = ['Centroids',slash];     %where to save it
        case 2
            dir_path = ['WeightedCentroids',slash];     %where to save it
        case 3
            dir_path = ['TotalPixel',slash];    %here to save it
    end
    
    mkdir(channel_paths,dir_path);      %create output directory
    mkdir(channel_paths,[dir_path,'img_data',filesep]);     %create a directory where the file information is stored
    for i = 1:size(centroid_stk,2)
        warning('OFF')
        %now save the files
        mkdir([channel_paths,dir_path],[stks_ch_names{1,i}(1:end-4),' ',num2str(size(pivots_out{1,i},1))]);
        xls_exp = dataset({pivots_out{1,i},mxlabel{:}});               %to export as a XLS need to make the data a dataset.
        %export(xls_exp,'XLSfile',[[channel_paths,dir_path],[stks_ch_names{1,i},'.xls']]);
        export(xls_exp,'File',[[channel_paths,dir_path],[stks_ch_names{1,i}(1:end-4),'.',num2str(size(pivots_out{1,i},1)),'.csv']],'delimiter',',')
        mkdir([channel_paths,dir_path,stks_ch_names{1,i}(1:end-4),' ',num2str(size(pivots_out{1,i},1))],['lum_stks',slash]);
        stk2tiff(lum_stk{1,i},stks_ch_names{1,i},[channel_paths,dir_path,stks_ch_names{1,i}(1:end-4),' ',num2str(size(pivots_out{1,i},1)),slash,'lum_stks',slash]);
        mkdir([channel_paths,dir_path,stks_ch_names{1,i}(1:end-4),' ',num2str(size(pivots_out{1,i},1))],['centroid_stks',slash]);
        stk2tiff(centroid_stk{1,i},stks_ch_names{1,i},[channel_paths,dir_path,stks_ch_names{1,i}(1:end-4),' ',num2str(size(pivots_out{1,i},1)),slash,'centroid_stks',slash]);
        if object   %save out the object stacks
            mkdir([channel_paths,dir_path,stks_ch_names{1,i}(1:end-4),' ',num2str(size(pivots_out{1,i},1))],['objects_lum',slash]);
            stk2tiff(object_lum{1,i},stks_ch_names{1,i},[channel_paths,dir_path,stks_ch_names{1,i}(1:end-4),' ',num2str(size(pivots_out{1,i},1)),slash,'objects_lum',slash]);
            mkdir([channel_paths,dir_path,stks_ch_names{1,i}(1:end-4),' ',num2str(size(pivots_out{1,i},1))],['objects',slash]);
            stk2tiff(object_stk{1,i},stks_ch_names{1,i},[channel_paths,dir_path,stks_ch_names{1,i}(1:end-4),' ',num2str(size(pivots_out{1,i},1)),slash,'objects',slash]);
        end
        %save some info about the image volume
        img_data = size(stks{i});
        img_data = dataset(img_data);
        export(img_data,'File',[[channel_paths,dir_path,'img_data',filesep],stks_ch_names{1,i}(1:end-4),'_img_data.csv'],'delimiter',',')
        %clear data
        local_max_tmp = []; lum_tmp = []; xls_exp = [];
        warning('ON')
    end
    
    %for historical reasons I am going to save this file, no big.
    export(img_data,'File',[[channel_paths,dir_path,'img_data',filesep],'img_data.csv'],'delimiter',',')
    %matlabpool close
end

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [stks,threshold,stks_ch_names,channel_paths,type,type2,norm,object,zfilter,sav] = parse(input)

threshold = [];    
stks = [];
type = 0;
type2 = 0;      %default is 0; now you can define the accessory data, acquired instead of Luminance
norm = 1;
object = 0;
sav = 1;
stks_ch_names = [];
channel_paths = [];
zfilter = 0;

%Parse the input
if ~isempty(input)
    for i = 1:2:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'threshold'
                    threshold = input{1,i+1};
                case 'stks'
                    stks = input{1,i+1};
                case 'type'
                    type = input{1,i+1};
                case 'type2'
                    type2 = input{1,i+1};
                case 'norm'
                    norm = input{1,i+1};
                case 'object'
                    object = input{1,i+1};
                case 'zfilter'
                    zfilter = input{1,i+1};
                case 'save'
                    sav = input{1,i+1};
                otherwise
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        else
            error(['The parameters you entered is incorrect.  Please check help.']);
        end
    end
end

%open the target images
if isempty(stks)
    prompt_box('title','Open Stacks','prompt1','Select stacks for ',...
        'prompt2','centroid processing','position','center');
    pause(0.25);
    [stks,img_range,stks_ch_names,channel_paths] = stack_gui(1);  %use cell output mode.
else
    %make sure the stks is a cell array
    if ~iscell(stks)
        stks = {stks};
    end
end
%set threshold, if the user have not already.
if isempty(threshold)
    switch type
        case 0   %default local max
            threshold = 0.1;
        otherwise  %centroid or weighted centroid
            threshold = 0.1;
    end
end
%create the actual threshold, which is percentage between the max and the
%min of each image.
% if ~isempty(threshold) && ~type     %only doing this local max
%     for i = 1:size(stks,2)
%         imgclass = class(stks{1,i});      %get image type
%         switch imgclass
%             case 'uint8'
%                 img_max = intmax('uint8');      %the image is unsigned 8bit
%             case 'uint16'
%                 img_max = intmax('uint16');     %the image is unsigned 16bit
%             case 'uint32'
%                 img_max = intmax('uint32');     %unsigned 32bit, like I said not full proof, but works for now.
%             case 'double'
%                 img_max = 1;        %double
%         end
%         thresh_tmp{1,i} = img_max*threshold;
% %         if norm %normalize the image before threshold
% %            thresh_tmp{1,i} = absmax(imnorm(stks{1,i}))*threshold;
% %         else
% %            thresh_tmp{1,i} = absmax(stks{1,i})*threshold;
% %         end
%     end
%     threshold = thresh_tmp;
% end
